from PIL import Image

# Read the SAT assignments from the text file
with open('Samples_16_20_10_5_.txt', 'r') as file:
    sat_assignments = file.readlines()

# Process each SAT assignment
for index, assignment in enumerate(sat_assignments):
    # Split the assignment into variables
    variables = assignment.strip().split()[:16]

    # Create a blank 5x5 image
    image = Image.new('1', (4, 4))

    # Set the pixel values based on the variables
    for i, variable in enumerate(variables):
        x = int(variable)
        pixel_value = 1 if x > 0 else 0
        image.putpixel((i % 4, i // 4), pixel_value)

    # Save the image
    image.save(f'image{index+1}.png')